/*------------------------------------------------------------------------------
						BLOOM
------------------------------------------------------------------------------*/

float4 BloomPass( float4 ColorInput2,float2 Tex  ) 
{
	float4 BlurColor2 =  0.0f;
	//float4 BKThreshold = 0.0f;
	float NRGSamples = 1.0f;
	NRGSamples = NUM_SAMPLES2 /2;
	float MaxSamples = (NUM_SAMPLES2+1)*(NUM_SAMPLES2+1);
	float Samplescaler = 0.0f;
	if (BloomWidth < 1) Samplescaler = -0.4;
	if (BloomWidth > 5) Samplescaler = 4.6;
	else	Samplescaler = BloomWidth - 0.4;
	float MaxDistance = sqrt(NRGSamples*NRGSamples*2*Samplescaler);
	float CurDistance = MaxDistance;
	float4 Blurtemp = 0;
	for(float Samplex = (- NRGSamples); Samplex < NRGSamples+1; Samplex = Samplex + 1)
	{
		for(float Sampley = (- NRGSamples); Sampley < NRGSamples+1; Sampley = Sampley + 1)
		{
			CurDistance = sqrt ( ((Samplex * Samplex) + (Sampley*Sampley))*Samplescaler);
			Blurtemp.rgb = tex2D(s0, float2(Tex.x +(Tex.x*Samplex*px*Samplescaler),Tex.y +(Tex.y*Sampley*py*Samplescaler)));
			BlurColor2.rgb += lerp(Blurtemp.rgb,ColorInput2.rgb, 1 - ((MaxDistance - CurDistance)/MaxDistance));
		}
	}
	float MinBloom = 0.0f;
	if (BloomThreshold < 1) MinBloom = 2;
	if (BloomThreshold > 9) MinBloom = 10;
	else MinBloom = BloomThreshold + 1; 
	BlurColor2.rgb = (BlurColor2.rgb / MaxSamples);
	float Bloomamount = (dot(ColorInput2.xyz,float3(0.299, 0.587, 0.114)) + MinBloom) ;
	float4	BlurColor = BlurColor2 * (BloomScale + 1);
	BlurColor2.rgb =lerp(ColorInput2,BlurColor, Bloomamount).rgb ;	
	BlurColor2.a = ColorInput2.a;
	return  BlurColor2;
}